#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
#include <cmath>

#define ll long long
#define pb push_back
#define dbl double
using namespace std;

const dbl eps = 0.00000001;

struct pt{
 ll x, y;
};

ll mlt (pt &a, pt &b){
    return a.x*b.y - a.y*b.x;
}

int sign(ll x){
    if (x < 0) return -1;
    if (x > 0) return 1;
    return 0;
}

bool fvn(pair<pt, pt> &a, pair<pt, pt> &b){
    dbl x1 = a.first.x;
    dbl y1 = a.first.y;
    dbl x2 = a.second.x;
    dbl y2 = a.second.y;
    dbl x3 = b.first.x;
    dbl y3 = b.first.y;
    if (abs((x2 - x1)/(y2 - y1) - (x3 - x1)/(y3 - y1)) < eps) return true;
    return false;
}

bool inters(pair<pt, pt> &a, pair<pt, pt> &b){
    pt p1 = {b.second.x - b.first.x, b.second.y - b.first.y};
    pt p2 = {a.second.x - b.first.x, a.second.y - b.first.y};
    pt p3 = {a.first.x - b.first.x, a.first.y - b.first.y};
    if (sign(mlt(p1, p2))*sign(mlt(p1, p3)) >= 0) return false;
    /////
    p1 = {a.second.x - a.first.x, a.second.y - a.first.y};
    p2 = {b.second.x - a.first.x, b.second.y - a.first.y};
    p3 = {b.first.x - a.first.x, b.first.y - b.first.y};
    if (sign(mlt(p1, p2))*sign(mlt(p1, p3)) >= 0) return false;
    ////
    return true;
}

int main()
{
    int t; cin >> t;
    for (int _ = 0; _ < t; ++_){
        int n; cin >> n;
        vector<pair<pt, pt> > v;
        ll vr = 0, r = 0;
        ll x1, y1, x2, y2;
        for (int i = 0; i < n; ++i){
            cin >> x1 >> y1 >> x2 >> y2;
            v.pb({{x1, y1}, {x2, y2}});
        }
        for (int i = 1; i < n; ++i){
            for (int j = 0; j < i; ++j){
                if (fvn(v[i], v[j]) || fvn(v[j], v[i])){
                    vr += 1;
                    continue;
                }
                if (inters(v[i], v[j])){
                    vr += 1;
                    r += 2;
                }
            }
        }
        cout << r - vr + 3 << endl;
    }
    return 0;
}
